<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->belongsTo('App\Model\PostCategory', 'id', 'category_id');
    }

    public function site()
    {
        return $this->hasOne('App\Model\Site', 'id', 'site_id');
    }

    public function user()
    {
        return $this->hasOne('App\User');
    }

}